/* globals getComputedStyle */
// This line removes the squiggly underline from `getComputedStyle`. It tells standard that `getComputedStyle` is already defined.

const carousel = document.querySelector('.carousel')
const previousButton = carousel.querySelector('.previous-button')
const nextButton = carousel.querySelector('.next-button')
const contents = carousel.querySelector('.carousel__contents')

nextButton.addEventListener('click', event => {
  const currentSlide = contents.querySelector('.is-selected')
  const nextSlide = currentSlide.nextElementSibling
  const destination = getComputedStyle(nextSlide).left

  // Shows next slide
  contents.style.left = '-' + destination
  currentSlide.classList.remove('is-selected')
  nextSlide.classList.add('is-selected')

  // Shows previous button
  previousButton.removeAttribute('hidden')

  // Hides next button
  if (!nextSlide.nextElementSibling) {
    nextButton.setAttribute('hidden', true)
  }
})

previousButton.addEventListener('click', event => {
  const currentSlide = contents.querySelector('.is-selected')
  const previousSlide = currentSlide.previousElementSibling
  const destination = getComputedStyle(previousSlide).left

  // Shows previous slide
  contents.style.left = '-' + destination
  currentSlide.classList.remove('is-selected')
  previousSlide.classList.add('is-selected')

  // Shows next button
  nextButton.removeAttribute('hidden')

  // Hides previous button
  if (!previousSlide.previousElementSibling) {
    previousButton.setAttribute('hidden', true)
  }
})
